/*
*******************************************************************************
*
* File:         pxcommon.h
* Description:
* Author:       Henrik Liebau
* Created:      05 Apr 2000, 09:24:05
* Modified:     Tue May 29 17:04:14 2001 by Henrik Liebau, BVS R&D
* Language:     C/C++ Include File
* Package:	PCI-X Protocol Permutator&Randomizer
* Status:
*
* (C) Copyright 2000 by Agilent Technologies, All Rights Reserved.
*
*******************************************************************************
*/

#ifndef __pxcommon_H__
#define __pxcommon_H__

/* include type definitions, if not already done */
#ifndef __pxdef_H__
#include <pxdef.h>
#endif /* defined __pxdef_H__ */

/* include type definitions, if not already done */
#ifndef __pxblkdef_H__
#include <pxblkdef.h>
#endif /* defined __pxblkdef_H__ */

/* make sure this also runs in C++ programs */
#ifdef __cplusplus
extern "C" {
#endif

/*****************************************************************************
 * non-exported PPR functions
 *****************************************************************************/

/*---------------------------------------------------------------------------*
 * PprVarDataDefaultSet
 *
 * Purpose	: Set PPR var and prop data to all default values
 *---------------------------------------------------------------------------*/
bx_errtype PprVarDataDefaultSet (
  bx_handletype handle,
  bxppr_vardatatype * varData
  );

/*----------------------------------------------------------------------------*
 * PprPropDefaultSet
 *
 * Set PPR Ri Block prop settings to defaults
 *---------------------------------------------------------------------------*/
bx_errtype PprPropDefaultSet (
  bx_handletype handle,
  bxppr_propdatatype * propData
  );

/*----------------------------------------------------------------------------*
 * PprPropSet
 *
 * Set / Get PPR Block requester initiator settings
 *---------------------------------------------------------------------------*/
bx_errtype PprPropSet (
  bx_handletype handle,
  bxppr_propdatatype * propData,
  bxppr_proptype prop,
  bx_int32 value
  );

/*----------------------------------------------------------------------------*
 * PprPropGet
 *
 * Get / Get PPR prop settings
 *---------------------------------------------------------------------------*/
bx_errtype PprPropGet (
  bxppr_propdatatype * propData,
  bxppr_proptype prop,
  bx_int32 * pValue
  );

/*----------------------------------------------------------------------------*
 * PprListDefaultSet
 *
 * set variation list to default
 *---------------------------------------------------------------------------*/
bx_errtype PprListDefaultSet (
  bx_handletype handle,
  bxppr_vardatatype * varData,
  bxppr_proptype prop
  );

/*----------------------------------------------------------------------------*
 * PprListSet/
 *
 * set variation list
 *---------------------------------------------------------------------------*/
bx_errtype PprListSet (
  bx_handletype handle,
  bxppr_vardatatype * varData,
  bxppr_proptype prop,
  bxppr_listtype  list
  );

/*----------------------------------------------------------------------------*
 * PprListGet/
 *
 * get variation list
 *---------------------------------------------------------------------------*/
bx_errtype PprListGet (
  bx_handletype handle,
  bxppr_vardatatype * varData,
  bxppr_proptype prop,
  bxppr_listtype * pList
  );

/*---------------------------------------------------------------------------*
 * void PprFillGenLists
 *
 * Purpose	: 
 *---------------------------------------------------------------------------*/
void PprFillGenLists ( bx_int32 * randomseed,
		       bx_int32 algorithm,
		       bx_int32 firstPerm,
		       bxppr_resulttype * result);

/*---------------------------------------------------------------------------*
 * double PprAssignPrimes
 *
 * Purpose	: 
 *---------------------------------------------------------------------------*/
double PprAssignPrimes ( bxppr_perminfotype * permArray,
			 bx_int32 numElem,
			 bx_int32 primeLimit );

/*---------------------------------------------------------------------------*
 *   bx_errtype PprDouble2ULong ( bx_int32 * to, double from );
 *
 * Purpose	: 
 *---------------------------------------------------------------------------*/
bx_errtype PprDouble2ULong ( bx_int32 * to, double from );

/*---------------------------------------------------------------------------*
 * bx_int32 PprPermutationValGet (bxppr_genlisttype * genList, bx_int32 index)
 *
 * Purpose	: get value for list at permutation index
 *		  NOTE that index is 1-based, while list is 0-based!
 *---------------------------------------------------------------------------*/
bx_int32 PprPermutationValGet (bxppr_genlisttype * genList, bx_int32 index);

/*---------------------------------------------------------------------------*
 * bx_errtype PprGenerate ( bx_handletype handle,
 *
 * Purpose	: generate all ppr permutations
 *---------------------------------------------------------------------------*/
bx_errtype PprGenerate ( bxppr_datatype * pprData,
			 bxppr_resultdatatype * resultData );
  
/*---------------------------------------------------------------------------*
 * bx_errtype PprProg
 *
 * Purpose	: generate all of PPR
 *---------------------------------------------------------------------------*/
bx_errtype PprProg ( bxppr_datatype * pprData );

/*---------------------------------------------------------------------------*
 * int PprTuplePermutate ( int * pPower, int * pNumber, int list[], int count );
 *
 * Purpose	: 
 *---------------------------------------------------------------------------*/
int PprTuplePermutate ( int * pPower, int * pNumber, int list[], int count );

#ifdef __cplusplus
}
#endif

#endif /* defined __pxcommon_H__ */
